/**
  ******************************************************************************
  * @file    py32f005_ll_opa.c
  * @author  MCU Application Team
  * @brief   OPA LL module driver.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2016 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */
#if defined(USE_FULL_LL_DRIVER)

/* Includes ------------------------------------------------------------------*/
#include "py32f005_ll_opa.h"
#include "py32f005_ll_bus.h"

/** @addtogroup PY32F005_LL_Driver
  * @{
  */

#if defined(OPA1)

/** @defgroup OPA_LL OPA
  * @{
  */

/* Private types -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private constants ---------------------------------------------------------*/
/* Private macros ------------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/

/* Exported functions --------------------------------------------------------*/
/** @addtogroup OPA_LL_Exported_Functions
  * @{
  */

/** @addtogroup OPA_LL_EF_Init
  * @{
  */

/**
  * @brief  De-initialize the OPA registers to their default reset values.
  * @retval An ErrorStatus enumeration value:
  *          - SUCCESS: OPA registers are de-initialized
  *          - ERROR: not applicable
  */
ErrorStatus LL_OPA_DeInit(OPA_TypeDef *OPAx)
{
  /* Force reset of OPA1 clock */
  LL_APB1_GRP1_ForceReset(LL_APB1_GRP1_PERIPH_OPA1);

  /* Release reset of OPA1 clock */
  LL_APB1_GRP1_ReleaseReset(LL_APB1_GRP1_PERIPH_OPA1);

  return SUCCESS;
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
#endif /* defined(OPA1) */
/**
  * @}
  */

#endif /* USE_FULL_LL_DRIVER */

/************************ (C) COPYRIGHT Puya *****END OF FILE******************/
